-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("trapRock")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
		self.p1 = Citadels.GetPlayer(1)
    
    if not self.loaded then
      self.active = false
      self.timer = 2.4
    end    
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.p0:KillUnitsInRadius(self:GetPosition(), 1000)
			self.p1:KillUnitsInRadius(self:GetPosition(), 1000)
      self.active = false
    end    
  end  
end

function OnTrigger(self, source, target)
  if target == "trapRock" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end